<?php
/**
 * Options map file
 */

if ( ! function_exists( 'eltd_membership_get_pages_list' ) ) {
	function eltd_membership_get_pages_list() {
		$all_pages = array();
		$pages     = get_pages();
		if ( ! empty( $pages ) ) {
			$all_pages[] = esc_html__( 'Default', 'eltd-membership' );

			foreach ( $pages as $page ) {
				$all_pages[ $page->ID ] = esc_html( $page->post_title );
			}
		}

		return $all_pages;
	}
}

if ( ! function_exists( 'eltd_membership_add_options' ) ) {
	/**
	 * Map plugin options
	 */
	function eltd_membership_add_options() {

		if ( eltd_membership_theme_installed() ) {

			$panel_social_login = findme_elated_add_admin_panel( array(
				'page'  => '_social_page',
				'name'  => 'panel_social_login',
				'title' => esc_html__('Enable Social Login', 'eltd-membership')
			) );

			findme_elated_add_admin_field(
				array(
					'type'          => 'text',
					'name'          => 'eltd_membership_privacy_policy_text',
					'label'         => esc_html__( 'Privacy Policy Text', 'eltd-membership' ),
					'description'   => esc_html__( 'Enter privacy policy text for registration modal form', 'eltd-membership' ),
					'parent'        => $panel_social_login
				)
			);

			findme_elated_add_admin_field(
				array(
					'type'          => 'select',
					'name'          => 'eltd_membership_privacy_policy_link',
					'label'         => esc_html__( 'Privacy Policy Link', 'eltd-membership' ),
					'description'   => esc_html__( 'Choose Privacy Policy Link page to link from registration modal form', 'eltd-membership' ),
					'default_value' => '',
					'options'       => eltd_membership_get_pages_list(),
					'parent'        => $panel_social_login
				)
			);

			findme_elated_add_admin_field(
				array(
					'type'          => 'text',
					'name'          => 'eltd_membership_privacy_policy_link_text',
					'label'         => esc_html__( 'Privacy Policy Link Text', 'eltd-membership' ),
					'description'   => esc_html__( 'Enter privacy policy link text for registration modal form. Default value is "privacy policy"', 'eltd-membership' ),
					'parent'        => $panel_social_login
				)
			);

			findme_elated_add_admin_field( array(
				'type'          => 'yesno',
				'name'          => 'enable_social_login',
				'default_value' => 'no',
				'label'         => esc_html__('Enable Social Login', 'eltd-membership'),
				'description'   => esc_html__('Enabling this option will allow login from social networks of your choice', 'eltd-membership'),
				'args'          => array(
					'dependence'             => true,
					'dependence_hide_on_yes' => '',
					'dependence_show_on_yes' => '#eltd_panel_enable_social_login'
				),
				'parent'        => $panel_social_login
			) );

			$panel_enable_social_login = findme_elated_add_admin_panel( array(
				'page'            => '_social_page',
				'name'            => 'panel_enable_social_login',
				'title'           => esc_html__('Enable Login via', 'eltd-membership'),
				'hidden_property' => 'enable_social_login',
				'hidden_value'    => 'no'
			) );

			findme_elated_add_admin_field( array(
				'type'          => 'yesno',
				'name'          => 'enable_facebook_social_login',
				'default_value' => 'no',
				'label'         => esc_html__('Facebook', 'eltd-membership'),
				'description'   => esc_html__('Enabling this option will allow login via Facebook', 'eltd-membership'),
				'args'          => array(
					'dependence'             => true,
					'dependence_hide_on_yes' => '',
					'dependence_show_on_yes' => '#eltd_enable_facebook_social_login_container'
				),
				'parent'        => $panel_enable_social_login
			) );

			$enable_facebook_social_login_container = findme_elated_add_admin_container( array(
				'name'            => 'enable_facebook_social_login_container',
				'hidden_property' => 'enable_facebook_social_login',
				'hidden_value'    => 'no',
				'parent'          => $panel_enable_social_login
			) );

			findme_elated_add_admin_field( array(
				'type'          => 'text',
				'name'          => 'enable_facebook_login_fbapp_id',
				'default_value' => '',
				'label'         => esc_html__('Facebook App ID', 'eltd-membership'),
				'description'   => esc_html__('Copy your application ID form created Facebook Application', 'eltd-membership'),
				'parent'        => $enable_facebook_social_login_container
			) );
		}
	}

	add_action( 'findme_elated_options_map', 'eltd_membership_add_options', 50 );

}
